package com.androidbook.simplemultimedia;

import java.io.FileOutputStream;
import java.util.List;
import java.util.ListIterator;
import android.app.Activity;
import android.app.WallpaperManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.hardware.Camera.Size;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.Toast;

public class StillImageActivity extends Activity {
    private static final String DEBUG_TAG = "StillImageActivity";
    final private static String STILL_IMAGE_FILE = "zdjecie.jpg";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.still);
        final CameraSurfaceView cameraView =
            new CameraSurfaceView(getApplicationContext());
        FrameLayout frame = (FrameLayout) findViewById(R.id.frame);
        frame.addView(cameraView);
        Button shared = (Button) findViewById(R.id.shared);
        shared.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                cameraView.capture(new Camera.PictureCallback() {
                    public void onPictureTaken(byte[] data, Camera camera) {
                        Log.v("Zdjęcie", "Dane zdjęcia pobrane z aparatu");
                        try {
                            Bitmap bm =
                                BitmapFactory.decodeByteArray(data, 0,
                                    data.length);
                            String fileUrl =
                                MediaStore.Images.Media.insertImage(
                                    getContentResolver(), bm,
                                    "Zdjęcie",
                                    "Przykładowe zdjęcie zrobione aparatem");
                            if (fileUrl == null) {
                                Log.d("Zdjęcie", "Nie udało się dodać zdjęcia");
                                return;
                            } else {
                                // Wymuszenie odświeżenia biblioteki multimediów.
                                // Nie konieczne, lecz wygodne do testowania.
                                Uri picUri = Uri.parse(fileUrl);
                                sendBroadcast(new Intent(
                                    Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, picUri));
                            }
                        } catch (Exception e) {
                            Log.e("Zdjęcie", "Błąd zapisu pliku", e);
                        }
                    }
                });
            }
        });
        Button capture = (Button) findViewById(R.id.capture);
        capture.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                Log.v(DEBUG_TAG, "Prośba o zrobienie zdjęcia");
                cameraView.capture(new Camera.PictureCallback() {
                    public void onPictureTaken(byte[] data, Camera camera) {
                        Log.v("Zdjęcie", "Dane zdjęcia pobrane z aparatu");
                        FileOutputStream fos;
                        try {
                            // Pełna nazwa pliku. W tym przypadku będzie on umieszczony w podkatalogu Files.
                            String pathForAppFiles =
                                getFilesDir().getAbsolutePath();
                            pathForAppFiles =
                                pathForAppFiles + "/" + STILL_IMAGE_FILE;
                            Log.d("Zdjęcie; nazwa pliku zdjęcia:", pathForAppFiles);
                            fos =
                                openFileOutput(STILL_IMAGE_FILE,
                                    MODE_WORLD_READABLE);
                            fos.write(data);
                            fos.close();
                        } catch (Exception e) {
                            Log.e("Zdjęcie", "Błąd zapisu do pliku", e);
                        }
                    }
                });
            }
        });
        Button paper = (Button) findViewById(R.id.wallpaper);
        paper.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                cameraView.capture(new Camera.PictureCallback() {
                    public void onPictureTaken(byte[] data, Camera camera) {
                        Log.v("Zdjęcie", "Dane zdjęcia pobrane z aparatu");
                        Bitmap recordedImage =
                            BitmapFactory.decodeByteArray(data, 0, data.length);
                        try {
                            WallpaperManager wpManager =
                                WallpaperManager
                                    .getInstance(StillImageActivity.this);
                            int height = wpManager.getDesiredMinimumHeight();
                            int width = wpManager.getDesiredMinimumWidth();
                            Toast.makeText(getApplicationContext(),
                                "Wymiary tapety = " + width + "x" + height,
                                Toast.LENGTH_LONG).show();
                            Log.v("Zdjęcie", "Wymiary tapety=" + width + "x"
                                + height);
                            Bitmap scaledImage =
                                Bitmap.createScaledBitmap(recordedImage, width,
                                    height, false);
                            wpManager.setBitmap(scaledImage);
                        } catch (Exception e) {
                            Log.e("Zdjęcie", "Nie udało się ustawić tapety.", e);
                        }
                    }
                });
            }
        });
    }

    private class CameraSurfaceView extends SurfaceView implements
        SurfaceHolder.Callback {
        private Camera camera = null;
        private SurfaceHolder mHolder = null;

        public CameraSurfaceView(Context context) {
            super(context);
            // Określamy SurfaceHolder.Callback 
            mHolder = getHolder();
            mHolder.addCallback(this);
            mHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width,
            int height) {
            try {
                Camera.Parameters params = camera.getParameters();
                // Nie wszystkie aparaty pozwalają na ustawianie dowolnych wymiarów.
                List<Camera.Size> sizes = params.getSupportedPreviewSizes();
                Camera.Size pickedSize = getBestFit(sizes, width, height);
                if (pickedSize != null) {
                    params.setPreviewSize(pickedSize.width, pickedSize.height);
                    Log.d(DEBUG_TAG, "Rozmiar podglądu: (" + pickedSize.width + ","
                        + pickedSize.height + ")");
                    // Nawet po określeniu obsługiwanego wymiaru, obszar podglądu 
                    // może mieć takie same wymiary jak obszar powierzchni.
                    camera.setParameters(params);
                }
                // Ustawiamy orientację pionową.
                // Można to robić wyłącznie w przypadku gdy znana jest orientacja 
                // urzadzenia (0,90,180 itd).
                // Działa tylko w API poziomu 8+
                camera.setDisplayOrientation(90);
                camera.startPreview();
            } catch (Exception e) {
                Log.e(DEBUG_TAG, "Nie udało się określić wymiarów podglądu", e);
            }
        }

        private Size getBestFit(List<Size> sizes, int width, int height) {
            Size bestFit = null;
            ListIterator<Size> items = sizes.listIterator();
            while (items.hasNext()) {
                Size item = items.next();
                if (item.width <= width && item.height <= height) {
                    if (bestFit != null) {
                        // Jeśli nasze aktualne najlepsze dopasowanie ma mniejszy obszar,
                        // to użyjemy nowego (większy obszar == lepsze dopasowanie).
                        if (bestFit.width * bestFit.height < item.width
                            * item.height) {
                            bestFit = item;
                        }
                    } else {
                        bestFit = item;
                    }
                }
            }
            return bestFit;
        }

        public void surfaceCreated(SurfaceHolder holder) {
            camera = Camera.open();
            try {
                camera.setPreviewDisplay(mHolder);
            } catch (Exception e) {
                Log.e(DEBUG_TAG, "Nie udało się określić obszaru podglądu aparatu", e);
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            camera.stopPreview();
            camera.release();
            camera = null;
        }

        public boolean capture(Camera.PictureCallback jpegHandler) {
            if (camera != null) {
                camera.takePicture(null, null, jpegHandler);
                return true;
            } else {
                return false;
            }
        }
    }
}
